#ifndef __C_PROTOCOLSTACK_H
#define __C_PROTOCOLSTACK_H

#include "Interfaces/cObject.h"
#include "Interfaces/cLayer.h"
#include "Util/cCriticalSection.h"
#include "cHandle.h"
#include <windows.h>

class cView;
class cDeliver;
class cCallback;
class cErrorCallback;
class cGroup;
class cMsgBuffer;
class cBufferManager;
class cLayerInfo;
class cHandle;
class cParam;
class cEndpoint;

//typedef void (*Function)(cObject* object);

/*
 * cProtocolStack.h
 *
 * The protocol stack.
 */
class cProtocolStack : public cObject
{

  public:

	// Constructor/destructor
	cProtocolStack(char* setupString);	// throws cException
	~cProtocolStack();

	// Send ops
	bool Send(cGroup* dest, char* buffer, int size, int messageType=MSG_TYPE_STANDARD);
	bool Send(cGroup* dest, cMsgBuffer* buffer, int messageType=MSG_TYPE_STANDARD);

	// Delivery Registration
	bool RegisterDeliverCallback(cHandle* handle, cDeliver* callback);
	bool UnregisterDeliverCallback(cHandle handle);
	bool RegisterViewCallback(cHandle* handle, cView* callback);
	bool UnregisterViewCallback(cHandle handle);
	bool RegisterErrorCallback(cHandle* handle, cErrorCallback* callback);
	bool UnregisterErrorCallback(cHandle handle);

	// Buffer pre-alloc
	cMsgBuffer*	AllocateBuffer(int size);	// Used so that can pre-alloc for 0 copy!

	// Layer management
	bool AddLayer(cLayer* newLayer, cParam* param);	// Adds from bottom up.
	cLayer* RemoveLayer();	// Removes from top down.

	// Layer control
	bool Schedule();
	bool Start();
	bool Stop();
	bool Cleanup();

	// Event management
	bool	AddEvent(HANDLE event, cCallback* callback, void* param);
	bool	RemoveEvent(HANDLE handle);

	// Info
	unsigned int GetMTS();

	// Time
	static void	 TimeStep(DWORD stepVal);	// Turns on simulation and steps time.
	static DWORD GetTime()
	{
		if(mSimulate)
		{
			return mCurrentTime;
		}
		else
		{
			return GetTickCount();
		}
	}	

	cGroup*	GetLocalAddress();
	bool	AddLocalAddress(cEndpoint* endpoint);


  private:

	// Time
	static bool		mSimulate;
	static DWORD	mCurrentTime;
	  
	// Thread Functions & members
	static DWORD WINAPI _ProtocolThread(LPVOID lpParameter);
	DWORD		  _Main();
	bool		  _StopMain();
	HANDLE		  mMainThreadHandle;	// thread handle of the main thread.
	DWORD		  mMainThreadId;		// id of the main thread.
	volatile bool mRunMain;				// Flag for thread execution.
	DWORD		  mNextSchedule;

	// Event stuff
	HANDLE*			mEventHandleArray;
	cCallback**		mCallbackArray;
	void**			mCallbackParamArray;
	HANDLE			mThreadStopEvent;
	unsigned int	mNumEvents;

	cGroup*			 mLocalAddressGroup;
	cLayer*			 mLayerBelow;
	unsigned int	 mCumHeaderSize;
	cCriticalSection mCS;

};

#endif
